'use strict';

function AccountDetailsCtrl($scope, $rootScope, BankAccountChanges, BanksList){
    var elementId = "#modal-chattel-account-changes";

    $scope.cbso = false;

    $scope.$on('Chattel:openAccountDetails', function(event, cbso){
        $scope.cbso = cbso;
        var message = {
            title: 'Szczegóły konta'
            ,msg: 'Trwa pobieranie danych. Proszę czekać...'
        }

        $scope.title = BanksList.getOptionFullName(cbso.option_id);

        $rootScope.$broadcast('Message:addMsg', message);

        BankAccountChanges.loadData(cbso.id, function(data){
            $rootScope.$broadcast('Message:delMsg', message);
            $scope.openModal();
            $scope.changes = data;
            setTimeout(function(){
                $("#modal-chattel-account-changes .nano").nanoScroller({alwaysVisible: true});
            }, 300);
        });
    });

    $scope.openModal = function(){
        angular.element(elementId).modal({
            backdrop: 'static'
            ,keyboard: false
            ,show: true
        });
    }

    $scope.closeModal = function(){
        angular.element(elementId).modal('hide');
    }

}

AccountDetailsCtrl.$inject = ['$scope', '$rootScope', 'BankAccountChanges', 'BanksList'];
